﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
    public enum VmInterfaceType
    {
        rtl8139_pv = 0,
        rtl8139 = 1,
        e1000 = 2,
        pv = 3
    }

	public partial class VmNetworkInterface
    {
        public VmNetworkInterface()
        {
            Statistics = new VmNetworkStatistics();
        }

		#region IVdcQueryable Members

		[XmlIgnoreAttribute]
		public override object QueryableId
		{
			get { return Id; }
		}

		private static readonly List<string> _interfaceProperties =
	new List<string>
    		{
 			"ReceiveRate",
			"TransmitRate",
			"TransmitDropRate",
			"ReceiveDropRate",
			"Type",
 			"Speed",
			"MacAddress",
			"NetworkName",
			"Name",
			"Status", 
			"VmId",
			"VmTemplateId", 
    		"VmName"
    		};

		[XmlIgnoreAttribute]
		public override List<string> ChangeablePropertiesList
		{
			get { return _interfaceProperties; }
		}

		#endregion
	}


	public partial class VdsNetworkInterface
	{
		public VdsNetworkInterface()
		{
			Statistics = new VdsNetworkStatistics();
        }

        #region IVdcQueryable Members

        [XmlIgnoreAttribute]
        public override object QueryableId
        {
            get { return Id; }
        }

		private static readonly List<string> _interfaceProperties =
			new List<string>
			{
			"ReceiveRate",
			"TransmitRate",
			"TransmitDropRate",
			"ReceiveDropRate",
			"Type",
			"Gateway",
			"Subnet",
			"Address",
			"Speed",
			"VlanId",
			"BondType",
			"BondName",
			"Bonded",
			"MacAddress",
			"NetworkName",
			"Name",
			"VdsId",
			"VdsName",
			"Status",
			"BootProtocol"
			};

        [XmlIgnoreAttribute]
        public override List<string> ChangeablePropertiesList
        {
            get { return _interfaceProperties; }
        }

        #endregion
    }
}
